//package globalExamples;

import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.express.olapi.transaction.ExpressTransactionProvider;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import java.sql.SQLException;

/**
 * Makes the connection to an Oracle Database instance that is used by the
 * SampleMetadataDiscoverer10g program, which Example 4-9, Discovering the
 * OLAP Catalog Metadata, from Chapter 4, Discovering the Available Metadata,
 * in the Oracle OLAP Developer's Guide to the OLAP API.
 *
 * @author Oracle Corporation
 */
public class MyConnection10g
{

private oracle.jdbc.OracleConnection _conn = null;
private Properties props = new Properties();
private boolean isVerbose = false;

  /**
   * Creates a new MyConnection10g object.
   */
  public MyConnection10g()
  {
  }

  /**
   * Creates a JDBC driver and an OracleConnection and connects to the
   * database specified in the input arguments.
   */
  public ExpressDataProvider connectToDB(String[] args, int outputStyle)
  {
    if (outputStyle == SampleMetadataDiscoverer10g.VERBOSE)
      isVerbose = true;

    if (isVerbose)
        System.out.println("Loading the JDBC driver...");

    try
    {
      Class.forName("oracle.jdbc.driver.OracleDriver");

      if (isVerbose)
        System.out.println("JDBC driver loaded.");
    }
    catch(Exception e)
    {
      System.out.println("Cannot not load the JDBC driver. " + e);
    }

    if (isVerbose)
      System.out.println("Setting up connection properties...");

    for (int i = 0; i < args.length; i += 2)
    {
	    if (i + 1 == args.length)
		  {
        throw new IllegalArgumentException("Command-line arguments must be " +
                   "specified in the form -<PropertyName> <PropertyValue>, " +
                   "with the name and value separated by whitespace.");
      }
	    props.put(args[i].substring(1), args[i + 1]);
    }

    // From the Properties object, get the command-line arguments that
    // specify the URL and the username and password to use in creating
    // the connection to the Oracle database.
    // The URL has the following information:
    //    An Oracle JDBC driver
    //    The server running the Oracle database
    //    The number of the port on which Oracle OLAP is listening
    //    The system identifier (SID) of the Oracle Database instance
    // To run the SampleMetadataDiscover10g program, specify a URL,
    // a username, and a password as command-line arguments in the
    // following format:
    //   -url jdbc:oracle:thin:@serverName:portNumber:sid -user username
    //   -password password
    // In the URL specification, replace  "serverName" with the hostname of
    // the server on which the Oracle Database instance is running.
    // Replace "portNumber" with the number of the TCP/IP listener port for
    // the database (which is 1521 by default).
    // Replace "sid" with the system identifier (SID) of the Oracle Database
    // instance to which you want to connect.
    // An example url is "jdbc:oracle:thin:@myOracleServer:1521:orcl".
    // The SampleMetadataDiscover10g program uses the Global schema.
    // To run the program, specify the username "global" and the
    // password "global".
    // An example of the command-line arguments is the following:
    //  -url jdbc:oracle:thin:@myOracleServer:1521:orcl -user global
    //  -password global

    String url = props.getProperty("url");
    String user = props.getProperty("user");
    String password = props.getProperty("password");

    if (isVerbose)
      System.out.println("Getting the connection...");

    try
    {
      _conn = (oracle.jdbc.OracleConnection)
             java.sql.DriverManager.getConnection(url, user, password);
      if (isVerbose)
        System.out.println("Connection made.");
    }
    catch(SQLException e)
    {
      System.out.println("Connection attempt failed." + e);
    }

    if (isVerbose)
      System.out.println("Getting the TransactionProvider...");
    ExpressTransactionProvider tp = new ExpressTransactionProvider();

    if (isVerbose)
      System.out.println("Getting the DataProvider...");

    ExpressDataProvider dp = new ExpressDataProvider(_conn, tp);
    try
    {
      if (isVerbose)
        System.out.println("Initializing the DataProvider...");

      dp.initialize();
    }
    catch(SQLException e)
    {
      System.out.println("Could not initialize the DataProvider." + e);
    }

    return dp;
  }

  /**
   * Closes the connection to the database.
   */
  public void closeConnection()
  {
    try
    {
      _conn.close();
    }
    catch(SQLException e)
    {
      System.out.println("Could not close the connection." + e);
    }
  }
}
